% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addUpwardMargin.R
\name{addUpwardMargin}
\alias{addUpwardMargin}
\title{Add upward margin of areas}
\usage{
addUpwardMargin(x)
}
\arguments{
\item{x}{An object of class \code{antaresData} created with
\code{\link[antaresRead]{readAntares}}}
}
\value{
The function modifies its input by adding to it two new columns
\code{isolatedUpwardMargin} and \code{interconnectedUpwardMargin}. For
convenience it invisibly returns \code{x}.
}
\description{
This function computes isolated and interconnected upward margins of areas and
add them to an antaresData object.
}
\details{
For a given area and time step, isolated upward margin is the difference
between the available production capacity plus the fatal productions and the
load. More formally it is equal to:

\code{isolatedUpwardMargin = (`AVL DTG` + hstorPMaxAvg + storageCapacity) +
                             (`H. ROR` + WIND + SOLAR + `MISC. NDG`) - LOAD}

The variable \code{storageCapacity} is automatically created when pumped
storage areas are removed with function
\code{\link[antaresRead]{removeVirtualAreas}}. If there is not any such area,
\code{storageCapacity} is assumed to be equal to 0.

Interconnected upward margin is the isolated upward margin plus the imports and
minus the exports:

\code{interconnectedUpwardMargin = isolatedUpwardMargin - BALANCE + `ROW BAL.`}
}
\examples{
\dontrun{
# Data required by the function
showAliases("upwardMargin")

mydata <- readAntares(select = "upwardMargin")
mydata <- removeVirtualAreas(mydata, getAreas(c("pump", "stor")))

addUpwardMargin(mydata)
}
}
