% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{t_test}
\alias{t_test}
\alias{t_test.default}
\alias{t_test.formula}
\title{Student's t-Test}
\usage{
t_test(x, ...)

\method{t_test}{default}(x, y = NULL, alternative = c("two.sided", "less",
  "greater"), mu = 0, paired = FALSE, var.equal = FALSE,
  conf.level = 0.95, ...)

\method{t_test}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.}

\item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{conf.level}{confidence level of the interval.}

\item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs}
    is a numeric variable giving the data values and \code{rhs} a factor
    with two levels giving the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
    \code{\link{model.frame}}) containing the variables in the
    formula \code{formula}.  By default the variables are taken from
    \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations
    to be used.}

\item{na.action}{a function which indicates what should happen when
    the data contain \code{NA}s.  Defaults to
    \code{getOption("na.action")}.}
}
\description{
A wrapper for \code{t.test} which includes the original data in the returned
object.
}
\seealso{
\link{t.test}
}
