% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_xaxis}
\alias{ax_xaxis}
\title{X-axis options}
\usage{
ax_xaxis(ax, type = NULL, categories = NULL, labels = NULL,
  axisBorder = NULL, axisTicks = NULL, tickAmount = NULL,
  min = NULL, max = NULL, range = NULL, floating = NULL,
  position = NULL, title = NULL, crosshairs = NULL, tooltip = NULL,
  ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{type}{Character. Available Options : \code{"categories"} and \code{"datetime"}.}

\item{categories}{Categories are labels which are displayed on the x-axis.}

\item{labels}{A list of parameters.}

\item{axisBorder}{A list of parameters.}

\item{axisTicks}{A list of parameters.}

\item{tickAmount}{Number of Tick Intervals to show.}

\item{min}{Lowest number to be set for the x-axis. The graph drawing beyond this number will be clipped off.}

\item{max}{Highest number to be set for the x-axis. The graph drawing beyond this number will be clipped off.}

\item{range}{Range takes the max value of x-axis, subtracts the provided range value and gets the min value based on that.
So, technically it helps to keep the same range when min and max values gets updated dynamically.}

\item{floating}{Logical. Floating takes x-axis is taken out of normal flow and places x-axis on svg element directly,
similar to an absolutely positioned element. Set the offsetX and offsetY then to adjust the position manually}

\item{position}{Setting this option allows you to change the x-axis position. Available options: \code{"top"} and \code{"bottom"}.}

\item{title}{A list of parameters.}

\item{crosshairs}{A list of parameters.}

\item{tooltip}{A list of parameters.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
X-axis options
}
\note{
See \url{https://apexcharts.com/docs/options/xaxis/}
}
\examples{
library(dplyr)
data("mpg", package = "ggplot2")

# X axis title
apex(
  data = count(mpg, manufacturer),
  mapping = aes(x = manufacturer, y = n)
) \%>\% 
  ax_xaxis(title = list(text = "Car's manufacturer"))

# force labels to rotate and increase height
apex(
  data = count(mpg, manufacturer),
  mapping = aes(x = manufacturer, y = n)
) \%>\% 
  ax_xaxis(labels = list(rotateAlways = TRUE, maxHeight = 180))

# force to not rotate
apex(
  data = count(mpg, manufacturer),
  mapping = aes(x = manufacturer, y = n)
) \%>\% 
  ax_xaxis(labels = list(rotate = 0, trim = FALSE))


data("economics", package = "ggplot2")

# Custom crosshair
apex(
  data = tail(economics, 50),
  mapping = aes(x = date, y = psavert),
  type = "line"
) \%>\% 
  ax_xaxis(
    crosshairs = list(
      opacity = 1,
      width = 2,
      fill = list(color = "red"),
      stroke = list(width = 0)
    )
  )


# Date format (zoom to see changes)
apex(
  data = tail(economics, 150),
  mapping = aes(x = date, y = psavert),
  type = "line"
) \%>\% 
  ax_xaxis(
    labels = list(
      datetimeFormatter = list(
        year = "yyyy-MM",
        month = "yyyy-MM-dd",
        day = "yyyy-MM-dd HH:mm"
      )
    )
  )
}
