% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_states}
\alias{ax_states}
\title{Charts' states}
\usage{
ax_states(ax, normal = NULL, hover = NULL, active = NULL, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{normal}{A list of parameters.}

\item{hover}{A list of parameters.}

\item{active}{A list of parameters.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Charts' states
}
\note{
See \url{https://apexcharts.com/docs/options/states/}
}
\examples{
library(dplyr)
data("mpg", package = "ggplot2")

# Inverse effect on hover
apex(
  data = count(mpg, manufacturer),
  mapping = aes(x = manufacturer, y = n),
  type = "bar"
) \%>\% 
  ax_states(
    hover = list(
      filter = list(
        type = "darken"
      )
    )
  )
}
