% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_yaxis2}
\alias{ax_yaxis2}
\title{Secondary Y-axis options}
\usage{
ax_yaxis2(ax, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{...}{See arguments from \code{\link{ax_yaxis}}.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Secondary Y-axis options
}
\examples{

library(dplyr)
data("economics_long", package = "ggplot2")

eco <- economics_long \%>\% 
  filter(variable \%in\% c("pce", "pop")) \%>\% 
  filter(date >= "2000-01-01")

apex(eco, aes(x = date, y = value, color = variable), type = "line") \%>\% 
  ax_yaxis(title = list(text = "Pce")) \%>\% 
  ax_yaxis2(opposite = TRUE, title = list(text = "Pop"))
  
}
