% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-options.R
\name{events_opts}
\alias{events_opts}
\title{Events options}
\usage{
events_opts(
  click = NULL,
  beforeMount = NULL,
  mounted = NULL,
  updated = NULL,
  legendClick = NULL,
  selection = NULL,
  dataPointSelection = NULL,
  dataPointMouseEnter = NULL,
  dataPointMouseLeave = NULL,
  beforeZoom = NULL,
  zoomed = NULL,
  scrolled = NULL,
  ...
)
}
\arguments{
\item{click}{Fires when user clicks on any area of the chart.}

\item{beforeMount}{Fires before the chart has been drawn on screen.}

\item{mounted}{Fires after the chart has been drawn on screen.}

\item{updated}{Fires when the chart has been dynamically updated.}

\item{legendClick}{Fires when user clicks on legend.}

\item{selection}{Fires when user selects rect using the selection tool.}

\item{dataPointSelection}{Fires when user clicks on a datapoint (bar/column/marker/bubble/donut-slice).}

\item{dataPointMouseEnter}{Fires when user’s mouse enter on a datapoint (bar/column/marker/bubble/donut-slice).}

\item{dataPointMouseLeave}{MouseLeave event for a datapoint (bar/column/marker/bubble/donut-slice).}

\item{beforeZoom}{This function, if defined, runs just before zooming in/out of the chart allowing you to set a custom range for zooming in/out.}

\item{zoomed}{Fires when user zooms in/out the chart using either the selection zooming tool or zoom in/out buttons.}

\item{scrolled}{Fires when user scrolls using the pan tool.}

\item{...}{Additional parameters.}
}
\value{
A \code{list} of options that can be used in \code{\link{ax_chart}}.
}
\description{
Events options
}
\note{
All arguments should be JavaScript function defined with \code{htmlwidgets::JS}.

See \url{https://apexcharts.com/docs/options/chart/events/}.
}
\examples{

if (interactive()) {
  library(shiny)
  
  ui <- fluidPage(
    fluidRow(
      column(
        width = 8, offset = 2,
        tags$h2("Apexchart in Shiny"),
        apexchartOutput("chart"),
        verbatimTextOutput(outputId = "res_click")
      )
    )
  )
  
  server <- function(input, output, session) {
    
    output$chart <- renderApexchart({
      apexchart() \%>\%
        ax_chart(
          type = "bar",
          events = events_opts(
            dataPointSelection = JS(
              "function(event, chartContext, config) {
               Shiny.setInputValue('click', config.selectedDataPoints)
              }"
            ) 
          )
        ) \%>\%
        ax_series(
          list(
            name = "Example",
            data = sample(1:100, 5)
          )
        ) \%>\%
        ax_xaxis(
          categories = LETTERS[1:5]
        )
    })
    
    output$res_click <- renderPrint({
      input$click
    })
  }
  
  shinyApp(ui, server)
}
}
