% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_dataLabels}
\alias{ax_dataLabels}
\title{Labels on data}
\usage{
ax_dataLabels(
  ax,
  enabled = NULL,
  textAnchor = NULL,
  offsetX = NULL,
  offsetY = NULL,
  style = NULL,
  dropShadow = NULL,
  formatter = NULL,
  ...
)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{enabled}{To determine whether to show dataLabels or not.}

\item{textAnchor}{The alignment of text relative to dataLabel's drawing position.
Accepted values \code{"start"}, \code{"middle"} or \code{"end"}.}

\item{offsetX}{Sets the left offset for dataLabels.}

\item{offsetY}{Sets the top offset for dataLabels.}

\item{style}{A list of parameters.}

\item{dropShadow}{A list of parameters.}

\item{formatter}{The formatter function takes in a single value and allows you to format the value before displaying}

\item{...}{Additional parameters.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Labels on data
}
\note{
See \url{https://apexcharts.com/docs/options/datalabels/}
}
\examples{
data("diamonds", package = "ggplot2")

# Add data labels
apex(
  data = diamonds,
  mapping = aes(x = cut)
) \%>\%
  ax_dataLabels(enabled = TRUE)
}
