% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_prepareProb.R
\name{apollo_prepareProb}
\alias{apollo_prepareProb}
\title{Checks that likelihoods are ready to be returned}
\usage{
apollo_prepareProb(P, apollo_control, functionality)
}
\arguments{
\item{P}{List. Each element contains the probabilities of a component of the model. Should contain one element called "model".}

\item{apollo_control}{List. Estimation settings. See \link{apollo_estimate}.}

\item{functionality}{Character. Can take different values depending on desired output of \code{apollo_probabilities}.
\describe{
  \item{"estimate"}{For model estimation, returns probabilities of chosen alternatives.}
  \item{"prediction"}{For model predictions, returns probabilities of all alternatives.}
  \item{"validate"}{Validates input.}
  \item{"zero_LL"}{Return probabilities with all parameters at zero.}
  \item{"conditionals"}{For conditionals, returns probabilities of chosen alternatives.}
  \item{"output"}{Checks that the model is well defined.}
  \item{"raw"}{For debugging, returns probabilities of all alternatives}
}}
}
\value{
The likelihood (i.e. probability in the case of choice models) of the model in the appropriate form for the given functionality.
}
\description{
Checks that likelihoods (i.e. probabilities in the case of choice models) are in the appropiate format to be returned.
}
\details{
This function should be called inside \code{apollo_probabilities}, near the end of it, just before \code{return(P)} and \code{apollo_detach()}.
This function only performs checks on the shape of P, but does not change its values in any way.
}
