% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_lcConditionals.R
\name{apollo_lcConditionals}
\alias{apollo_lcConditionals}
\title{Calculates conditionals of a latent class model.}
\usage{
apollo_lcConditionals(model, apollo_probabilities, apollo_inputs)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
A matrix with the posterior class allocation probabilities for each individual.
}
\description{
Calculates posterior expected values (conditionals) of class allocation probabilities for each individual.
}
\details{
This function can only be used with latent class models without continuous heterogeneity.
}
