% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc_geo_categories.R
\name{arc_geo_categories}
\alias{arc_geo_categories}
\title{Geocode places on a given area by category}
\usage{
arc_geo_categories(
  category,
  x = NULL,
  y = NULL,
  bbox = NULL,
  name = NULL,
  lat = "lat",
  long = "lon",
  limit = 1,
  full_results = FALSE,
  verbose = FALSE,
  custom_query = list(),
  ...
)
}
\arguments{
\item{category}{A place or address type that can be used to filter results.
Several values can be used as well as a comma-separated string (i.e.
\verb{"Cinema,Museum}). See \link{arc_categories} for details.}

\item{x}{longitude values in numeric format. Must be in the range
\verb{[-180, 180]}.}

\item{y}{latitude values in numeric format. Must be in the range
\verb{[-90, 90]}.}

\item{bbox}{A numeric vector of latitude and longitude
\code{c(minX, minY, maxX, maxY)} that restrict the search area.
See \strong{Details}.}

\item{name}{Optionally, a string indicating the name or address of the
desired results.}

\item{lat}{latitude column name in the output data (default  \code{"lat"}).}

\item{long}{longitude column name in the output data (default  \code{"lon"}).}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{returns all available data from the API service. This
is a shorthand of \verb{outFields=*}. See \strong{References}.
If \code{FALSE} (default) only the default values of the API would be returned.
See also \code{return_addresses}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list.}

\item{...}{
  Arguments passed on to \code{\link[=arc_geo]{arc_geo}}
  \describe{
    \item{\code{sourcecountry}}{Limits the candidates returned to the specified country
or countries. Acceptable values include the three-character country code.
You can specify multiple country codes to limit results to more than one
country.}
    \item{\code{outsr}}{The spatial reference of the \verb{x,y} coordinates returned by a
geocode request. By default is \code{NULL} (i.e. the parameter won't be used in
the query). See \strong{Details} and \link{arc_spatial_references}.}
    \item{\code{langcode}}{Sets the language in which reverse-geocoded addresses are
returned.}
  }}
}
\value{
A \CRANpkg{tibble} with the results. See the details of the output
in \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-service-output.htm}{ArcGIS REST API Service output}
}
\description{
This function is useful for extracting places with a given category (or list
of categories) near or within a given location or area. This is a wrapper
of \code{\link[=arc_geo]{arc_geo()}}.

See \link{arc_categories} for a detailed explanation and available values.

\strong{Note that} for obtaining results it is needed:
\itemize{
\item Either to provide a pair of coordinates (\verb{x,y} parameters) that would be
used as a reference for geocoding,
\item Or a viewbox (aka bounding box) on the \code{bbox} parameter defining an
desired extent of the results.
}

It is possible to combine the two approaches (i.e. providing \verb{x,y,bbox}
values) in order to boost the geocoding process. See \strong{Examples}.
}
\details{
Bounding boxes can be located using different online tools, as
\href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.

For a full list of valid categories see \link{arc_categories}.
}
\section{\code{outsr}}{
The spatial reference can be specified as either a well-known ID (WKID). If
not specified, the spatial reference of the output locations is the same as
that of the service ( WGS84, i.e. WKID = 4326)).

See \link{arc_spatial_references} for values and examples.
}

\examples{
\dontshow{if (arcgeocoder_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Full workflow: Gas Stations near Carabanchel, Madrid

# Get Carabanchel
carab <- arc_geo("Carabanchel, Madrid, Spain")

# Ex1: Search near Carabanchel (not restricted)
ex1 <- arc_geo_categories("Gas Station",
  # Location
  x = carab$lon, y = carab$lat,
  limit = 50, full_results = TRUE
)

plot(carab$lon, carab$lat,
  col = "red", pch = 19, cex = 3,
  xlim = c(-3.8, -3.65), ylim = c(40.3, 40.5),
  xlab = "long", ylab = "lat", main = "Example 1: Search near"
)

# BBox of Carabanchel
rect(carab$xmin, carab$ymin, carab$xmax, carab$ymax,
  border = "blue",
  col = NULL
)
# Points may be far away
points(ex1$lon, ex1$lat)


# Example 2: Include part of the name, different results

ex2 <- arc_geo_categories("Gas Station",
  # Name
  name = "Repsol",
  # Location
  x = carab$lon, y = carab$lat,
  limit = 50, full_results = TRUE
)


plot(carab$lon, carab$lat,
  col = "red", pch = 19, cex = 3,
  xlim = c(-3.8, -3.65), ylim = c(40.3, 40.5),
  xlab = "long", ylab = "lat", main = "Example 2: Search near with name"
)
# BBox of Carabanchel
rect(carab$xmin, carab$ymin, carab$xmax, carab$ymax,
  border = "blue",
  col = NULL
)
# Points may be far away
points(ex2$lon, ex2$lat)

# Example 3: Near within a extent

ex3 <- arc_geo_categories("Gas Station",
  name = "Repsol",
  bbox = c(carab$xmin, carab$ymin, carab$xmax, carab$ymax),
  limit = 50, full_results = TRUE
)


plot(carab$lon, carab$lat,
  col = "red", pch = 19, cex = 3,
  xlim = c(-3.8, -3.65), ylim = c(40.3, 40.5),
  xlab = "long", ylab = "lat",
  main = "Example 3: Search near with name and bbox"
)
# BBox of Carabanchel
rect(carab$xmin, carab$ymin, carab$xmax, carab$ymax,
  border = "blue",
  col = NULL
)
# Points may be far away
points(ex3$lon, ex3$lat)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-category-filtering.htm}{ArcGIS REST Category filtering}.

\link{arc_categories}

Geocoding operations: 
\code{\link{arc_geo_multi}()},
\code{\link{arc_geo}()},
\code{\link{arc_reverse_geo}()}
}
\concept{geocoding}
