\name{TRBPottery}
\alias{TRBPottery}
\docType{data}
\title{
Neolithic TRB Pottery from Demark
}
\description{
Measurements at 8 landmarks along one side of 118 Neolithic TRB (Trichterrandbecherkultur, Funnelneckbeaker culture) pottery vessels representing 3 different groups.
}
\usage{data("TRBPottery")}
\format{
  A data frame with 118 observations on the following 17 variables.
  \describe{
    \item{\code{Form}}{a factor with levels \code{Funnel beakers}, \code{Bowls}, and \code{Flasks}}
    \item{\code{AX}}{Point 1, x}
    \item{\code{AY}}{Point 1, y}
    \item{\code{BX}}{Point 2, x}
    \item{\code{BY}}{Point 2, y}
    \item{\code{CX}}{Point 3, x}
    \item{\code{CY}}{Point 3, y}
    \item{\code{DX}}{Point 4, x}
    \item{\code{DY}}{Point 4, y}
    \item{\code{EX}}{Point 5, x}
    \item{\code{EY}}{Point 5, y}
    \item{\code{FX}}{Point 6, x}
    \item{\code{FY}}{Point 6, y}
    \item{\code{GX}}{Point 7, x}
    \item{\code{GY}}{Point 7, y}
    \item{\code{HX}}{Point 8, x}
    \item{\code{HY}}{Point 8, y}
  }
}
\details{
The data are based on a study by E. K. Nielsen (1983) of Neolithic Pottery of 135 complete pots. The measurements are taken at landmarks identified along the profile of each pot (see Madsen, 1988 Figure 5). The data were reanalyzed by Madsen (1988). Baxter (1994) reanalyzed the data using several different methods. The data were scanned from Table 1 in Madsen (1988, p. 18) which included only 118 pots.
}
\source{
Madsen, T. 1988. Multivariate Statistics and Archaeology. In \emph{Multivariate Archaeology: Numerical Approaches in Scandinavian Archaeology}, edited by T. Madsen, pp 7 - 28.

Nielsen, E. K. 1983. Tidligneolitiske Keramikfund. Unpublished thesis. Institute of Archaeology, University of Copenhagen.
}
\references{
Baxter, M. J. 1994. \emph{Exploratory Multivariate Analysis in Archaeology}. Edinburgh University Press, pp 128-132.
}
\examples{
data(TRBPottery)
TRBPottery.frm <- aggregate(TRBPottery[, -1], list(Form=TRBPottery$Form), mean)
Xvals <- TRBPottery.frm[, seq(2, 16, by=2)]
Yvals <- TRBPottery.frm[, seq(3, 17, by=2)]
matplot(t(Xvals), t(Yvals), xlab="X", ylab="Y", type="l", asp=1, las=1, col="black", lwd=2)
legend("topleft", levels(TRBPottery$Form), lty=1:3, col="black", lwd=2)
}
\keyword{datasets}
