% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{drug_fips_biz}
\alias{drug_fips_biz}
\title{Download raw prescription data for individual drugs and business type by county FIPS code into R}
\usage{
drug_fips_biz(
  drug = "Fentanyl",
  fips = "01001",
  buyer_bus_act = "Chain Retail",
  key = "WaPo"
)
}
\arguments{
\item{drug}{Filter the data to one of 14 available drugs in the database (e.g. 'OXYCODONE')}

\item{fips}{Filter the data to only this county (e.g. ‘01001’ for Autauga, Alabama)}

\item{buyer_bus_act}{If provided, filter the data to one of businesses in BUYER_BUS_ACT (e.g. 'CHAIN PHARMACY', 'HOSP/CLINIC')}

\item{key}{Key needed to make query successful}
}
\description{
Data from from non-contiguous states not yet processed and available.
}
\examples{
\donttest{
library(arcos)

autauga_al <- drug_fips_biz(drug="Fentanyl", fips="01001", buyer_bus_act="Chain Retail", key="WaPo")

head(autauga_al)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other raw data: 
\code{\link{buyer_list}()},
\code{\link{county_list}()},
\code{\link{county_raw_fips}()},
\code{\link{county_raw}()},
\code{\link{drug_county_biz}()},
\code{\link{drug_list}()},
\code{\link{pharmacy_raw}()},
\code{\link{raw_data}()}
}
\concept{raw data}
