% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarized.R
\name{total_manufacturers_state}
\alias{total_manufacturers_state}
\title{Get total pills for each manufacturer in a state}
\usage{
total_manufacturers_state(state = "WV", key = "WaPo")
}
\arguments{
\item{state}{Filter the data to county within this state (e.g. 'WV')}

\item{key}{Key needed to make query successful}
}
\description{
Get total pills for each manufacturer in a state
}
\examples{
\donttest{
library(arcos)

wv <- total_manufacturers_state(state="WV", key="WaPo")

head(wv)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other summarized: 
\code{\link{buyer_details}()},
\code{\link{combined_buyer_annual}()},
\code{\link{combined_buyer_monthly}()},
\code{\link{summarized_county_annual}()},
\code{\link{summarized_county_monthly}()},
\code{\link{total_distributors_county}()},
\code{\link{total_distributors_state}()},
\code{\link{total_manufacturers_county}()},
\code{\link{total_pharmacies_county}()},
\code{\link{total_pharmacies_state}()}
}
\concept{summarized}
