% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvertibleQ.R
\name{IdentInvertQ}
\alias{IdentInvertQ}
\title{Checks invertibility, stationarity, and identifiability of a given set of
parameters}
\usage{
IdentInvertQ(phi = numeric(0), theta = numeric(0), phiseas = numeric(0),
  thetaseas = numeric(0), dfrac = numeric(0), dfs = numeric(0),
  H = numeric(0), Hs = numeric(0), alpha = numeric(0),
  alphas = numeric(0), delta = numeric(0), period = 0, debug = FALSE,
  ident = TRUE)
}
\arguments{
\item{phi}{The autoregressive parameters in vector form.}

\item{theta}{The moving average parameters in vector form.  See Details for
differences from \code{\link{arima}}.}

\item{phiseas}{The seasonal autoregressive parameters in vector form.}

\item{thetaseas}{The seasonal moving average parameters in vector form.  See
Details for differences from \code{\link{arima}}.}

\item{dfrac}{The fractional differencing parameter.}

\item{dfs}{The seasonal fractional differencing parameter.}

\item{H}{The Hurst parameter for fractional Gaussian noise (FGN).  Should
not be mixed with \code{dfrac} or \code{alpha}: see "Details".}

\item{Hs}{The Hurst parameter for seasonal fractional Gaussian noise (FGN).
Should not be mixed with \code{dfs} or \code{alphas}: see "Details".}

\item{alpha}{The decay parameter for power-law autocovariance (PLA) noise.
Should not be mixed with \code{dfrac} or \code{H}: see "Details".}

\item{alphas}{The decay parameter for seasonal power-law autocovariance
(PLA) noise.  Should not be mixed with \code{dfs} or \code{Hs}: see
"Details".}

\item{delta}{The delta parameters for transfer functions.}

\item{period}{The periodicity of the seasonal components.  Must be >= 2.}

\item{debug}{When TRUE and model is not stationary/invertible or
identifiable, prints some helpful output.}

\item{ident}{Whether to test for identifiability.}
}
\value{
TRUE if the model is stationary, invertible and identifiable.  FALSE
otherwise.
}
\description{
Computes whether a given long memory model is invertible, stationary, and
identifiable.
}
\details{
This function tests for identifiability via the information matrix of the
ARFIMA process.  Whether the process is stationary or invertible amounts to
checking whether all the variables fall in correct ranges.

The moving average parameters are in the Box-Jenkins convention: they are
the negative of the parameters given by \code{\link{arima}}.

If \code{dfrac}/\code{H}/\code{alpha} are mixed and/or
\code{dfs}/\code{Hs}/\code{alphas} are mixed, an error will not be thrown,
even though only one of these can drive the process at either level. Note
also that the FGN or PLA have no impact on the identifiability of the model,
as information matrices containing these parameters currently do not have
known closed form.  These two parameters must be within their correct ranges
(0<H<1 for FGN and 0 < alpha < 3 for PLA.)
}
\examples{

IdentInvertQ(phi = 0.3, theta = 0.3)
IdentInvertQ(phi = 1.2)

}
\references{
McLeod, A.I. (1999) Necessary and sufficient condition for
nonsingular Fisher information matrix in ARMA and fractional ARMA models The
American Statistician 53, 71-72.

Veenstra, J. and McLeod, A. I. (2012, Submitted) Improved Algorithms for
Fitting Long Memory Models: With R Package
}
\seealso{
\code{\link{iARFIMA}}
}
\author{
Justin Veenstra
}
\keyword{ts}
