% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argparser.R
\name{add_argument}
\alias{add_argument}
\title{Add an argument to a parser.}
\usage{
add_argument(parser, arg, help, default = NULL, type = NULL, nargs = NULL,
  flag = NULL, short = NULL)
}
\arguments{
\item{parser}{an \code{arg.parser} object}

\item{arg}{argument name (use no prefix for positional arguments,
\code{--} or \code{-} prefix for optional arguments or flags)}

\item{help}{help description for the argument}

\item{default}{default value for the argument [default: NA]}

\item{type}{variable type of the argument (which can be inferred from 
\code{default}); assumed to be \code{character} otherwise}

\item{nargs}{number of argument values (which can be inferred from 
\code{default}); set to \code{Inf} for an indefinite number;
an optional argument with an indefinite number of values may
need to be followed by another optional argument or flag (e.g.
\code{--}) to separate the indefinite optional argument from
possible position arguments}

\item{flag}{whether argument is a flag (and does not consume a value)
[default: FALSE]}

\item{short}{short-form for flags and positional arguments;
short-forms can be assigned automatically based on the first
character of the argument name, unless a conflict arises with
an existing short-form; to avoid conflicts, add the argument 
as early as possible}
}
\value{
an \code{arg.parser} object with the argument added
}
\description{
This function adds an argument to an \code{arg.parser} object and returns 
the modified object.
}
\details{
This function supports multiple arguments in a vector. To ensure that the
argument variable type is set correctly, either specify \code{type} directly
or supply \code{default} argument values as a list. Argument names
that contain dash \code{-} in the stem are converted to \code{_}.
}
\examples{
p <- arg_parser("A text file modifying program")

# Add a positional argument
p <- add_argument(p, "input", help="input file")

# Add an optional argument
p <- add_argument(p, "--output", help="output file", default="output.txt")

# Add a flag
p <- add_argument(p, "--append", help="append to file", flag=TRUE)

# Add multiple arguments together
p <- add_argument(p,
    c("ref", "--date", "--sort"),
    help = c("reference file", "date stamp to use", "sort lines"),
    flag = c(FALSE, FALSE, TRUE))

# Print the help message
print(p)

}

