\name{Agrawal}
\alias{Agrawal}
\alias{Agrawal.pat}
\alias{Agrawal.db}
\docType{data}
\title{Synthetic Example Dataset Agrawal}
\description{
This dataset is generated by the method described by Agrawal and Srikant (1994)
using the reimplementation in \pkg{arules} which also retains the patterns used
in the generation process.
}
\usage{data(Agrawal)}
\format{
  The format is:
 \code{transactions} \code{Agrawal.db}
 \code{itemsets} \code{Agrawal.pat}
}
\details{
 \code{Agrawal.db} contains the dataset (1000 items/20000 transactions) 
 and \code{Agrawal.pat} contains the
 patterns that were used to create the dataset.
}
\references{
    Rakesh Agrawal and Ramakrishnan Srikant (1994). Fast algorithms
    for mining association rules in large databases. In Jorge B.
    Bocca, Matthias Jarke, and Carlo Zaniolo, editors,  \emph{Proceedings
    of the 20th International Conference on Very Large Data Bases,
    VLDB}, pages 487-499, Santiago, Chile.
}
\examples{
data(Agrawal)

summary(Agrawal.pat)
summary(Agrawal.db)

## the data sets was generated with the following code
\dontrun{
Agrawal.pat <- random.patterns(1000, nPats = 2000,  method = "agrawal", 
    lPats = 2, corr = 0.5, cmean = 0.5, cvar = 0.1, iWeight = NULL,
    verbose = FALSE)
Agrawal.db <- random.transactions(1000, 20000, method="agrawal", 
    patterns = Agrawal.pat)
} 
}
\keyword{datasets}
