% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{init_knitr_engine}
\alias{init_knitr_engine}
\title{Initialize the asciicast knitr engine}
\usage{
init_knitr_engine(
  echo = FALSE,
  same_process = TRUE,
  timeout = 10,
  allow_errors = TRUE,
  startup = NULL,
  record_env = NULL,
  echo_input = TRUE,
  options = asciicast_knitr_options()
)
}
\arguments{
\item{echo}{Whether to print the code of asciicast chunks.}

\item{same_process}{Whether to run all asciicast chunks \emph{in the same}
R process. To restart this R process, call \code{init_knitr_engine()}
again.}

\item{timeout}{Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops. Update this for slow running code, that produces no
output as it runs.}

\item{allow_errors}{Whether to cast errors properly. If this is set to
\code{TRUE}, then asciicast overwrites the \code{"error"} option. Only change
this if you know what you are doing.}

\item{startup}{Quoted language object to run in the subprocess before
starting the recording.}

\item{record_env}{Environment variables to set for the R subprocess.}

\item{echo_input}{Whether to echo the input in the asciicast recording.}

\item{options}{R options to set (via \code{\link[base:options]{base::options()}}, in the background
R process that performs the recording. See \code{asciicast_knitr_options()}
for the defaults.}
}
\description{
Call this function in your Rmd file, to enable creating asciinema
casts from code chunks.
}
\section{Examples}{

Call this function from an Rmd chunk and then you can use the asciicast
knitr engine:\preformatted{```\{r echo = FALSE, results = "hide"\}
asciicast::init_knitr_engine()
```
}\preformatted{```\{asciicast, cache = TRUE\}`
#' Rows: 10
# This is an asciicast example
loadedNamespaces()
```
}
}

\seealso{
Other asciicast in Rmd: 
\code{\link{asciicast_knitr_options}()}
}
\concept{asciicast in Rmd}
