% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-atomic-recursive-vector.R, R/is-atomic-recursive-vector.R
\name{assert_is_atomic}
\alias{assert_is_atomic}
\alias{assert_is_nested}
\alias{assert_is_non_nested}
\alias{assert_is_recursive}
\alias{assert_is_vector}
\alias{is_atomic}
\alias{is_nested}
\alias{is_non_nested}
\alias{is_recursive}
\alias{is_vector}
\title{Is the input atomic/recursive/vector?}
\usage{
assert_is_atomic(x, severity = getOption("assertive.severity", "stop"))

assert_is_nested(x, severity = getOption("assertive.severity", "stop"))

assert_is_non_nested(x, severity = getOption("assertive.severity", "stop"))

assert_is_recursive(x, severity = getOption("assertive.severity", "stop"))

assert_is_vector(x, severity = getOption("assertive.severity", "stop"))

is_atomic(x, .xname = get_name_in_parent(x))

is_nested(x, .xname = get_name_in_parent(x))

is_non_nested(x, .xname = get_name_in_parent(x))

is_recursive(x, .xname = get_name_in_parent(x))

is_vector(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_atomic}, \code{is_recursive} and \code{is_vector} wrap 
\code{is.atomic}, \code{is.recursive} and \code{is.vector} respectively,
providing more information on failure.  
\code{is_nested} checks for recursive objects where at least one element is
also recursive. \code{is_non_nested} returns \code{TRUE} for atomic objects
and recursive objects where no elements are recursive.
The \code{assert_*} functions return nothing but throw an error if the 
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is a type that is atomic/recursive/vector.
}
\examples{
atomic_types <- list(
  logical(),
  integer(),
  numeric(), 
  complex(),
  character(), 
  raw(),
  matrix(), 
  array(),
  factor(),
  NULL
)
for(var in atomic_types) assert_is_atomic(var)

recursive_types <- list(
  list(), 
  expression(),
  data.frame(), 
  y ~ x,
  function(){},
  call("sin", "pi")
)
for(var in recursive_types) assert_is_recursive(var)

# Names are neither atomic nor recursive
a_name <- as.name("x")
is_atomic(a_name)
is_recursive(a_name)

vector_types <- c(
  atomic_types[1:6], 
  recursive_types[1:2]
)
for(var in vector_types) assert_is_vector(var)

# Nested objects are recursive and have at least one recursive element
nested_list <- list(a = 1, b = list(2:3))
assert_is_nested(nested_list)
for(elt in nested_list) assert_is_non_nested(elt)
}
\seealso{
\code{\link[base]{is.atomic}} and \code{\link[base]{is.vector}}.
}

