% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_NA.R
\name{replace_NA}
\alias{replace_NA}
\alias{replace_NA.character}
\alias{replace_NA.factor}
\alias{replace_NA.ordered}
\alias{replace_NA.data.frame}
\alias{replace_NA.list}
\alias{replace_NA.default}
\title{Replaces NA}
\usage{
replace_NA(x, ...)

\method{replace_NA}{character}(x, replacement = atable_options("replace_NA_by"), ...)

\method{replace_NA}{factor}(x, ...)

\method{replace_NA}{ordered}(x, ...)

\method{replace_NA}{data.frame}(x, ...)

\method{replace_NA}{list}(x, ...)

\method{replace_NA}{default}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Passed to methods.}

\item{replacement}{A character of length 1. Default value is defined
in \code{atable_options('replace_NA_by')}, see \code{\link{atable_options}}.}
}
\value{
Same class as \code{x}, now with \code{NA} replaced by \code{replacement}.
}
\description{
Replaces \code{NA} in characters, factors and data.frames.
}
\details{
The atable package aims to create readable tables. For non-computer-affine
readers \code{NA} has no meaning. So \code{replace_NA} exists.

Methods for character, factor, ordered, list and data.frame available.
Default method returns \code{x} unchanged.

Gives a warning when \code{replacement} is already present in \code{x} and
does the replacement.

Silently returns \code{x} unchanged when there are no \code{NA} in \code{x}.

Silently returns \code{x} unchanged when replacement is not a character of
length 1 or when replacement is \code{NA}.
}
\section{Methods (by class)}{
\itemize{
\item \code{replace_NA(character)}: replaces \code{NA} with \code{replacement}.

\item \code{replace_NA(factor)}: applies \code{replace_NA} to the levels of the factor. A
factor with length > 0 without levels will get the level \code{replacement}.

\item \code{replace_NA(ordered)}: as factor.

\item \code{replace_NA(data.frame)}: applies \code{replace_NA} to all columns.

\item \code{replace_NA(list)}: applies \code{replace_NA} to all elements of the list.

\item \code{replace_NA(default)}: return \code{x} unchanged.

}}
\examples{
Character <- c(NA,letters[1:3], NA)
Factor <- factor(Character)
Ordered <- ordered(Factor)
Numeric <- rep(1, length(Factor))
Factor_without_NA <- factor(letters[1:length(Factor)])

DD <- data.frame(Character, Factor, Ordered,
                Numeric, Factor_without_NA,
                stringsAsFactors = FALSE)
\dontrun{
DD2 <- replace_NA(DD, replacement = 'no value')

summary(DD)
summary(DD2) # now with 'no value' instead NA in column Character, Factor and Ordered

atable_options(replace_NA_by = 'not measured') # use atable_options to set replacement
DD3 <- replace_NA(DD)
summary(DD3) # now with 'not measured' instead NA

atable_options_reset() # set 'replace_NA_by' back to default
}
}
