% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/save_connection.R
\name{save_connection}
\alias{save_connection}
\title{Write connection parameters to configuration file.}
\usage{
save_connection(url = NA, user = NA, password = NA, verify = NA,
  encryption = NA)
}
\arguments{
\item{url}{Optional string argument. The url of ATSD with the port number.}

\item{user}{Optional string argument. The user name.}

\item{password}{Optional string argument. The user's password.}

\item{verify}{Optional string argument -- "yes" or "no".
     \code{verify = "yes"}  ensures validation of ATSD SSL certificate and
     \code{verify = "no"}  suppresses the validation
     (applicable in the case of 'https' protocol).}

\item{encryption}{Optional string argument.
     Cryptographic protocol used by ATSD https server.
     Possible values are: "default", "ssl2", "ssl3", and "tls1"
     (In most cases, use "ssl3" or "tls1".)}
}
\description{
The function writes the connection parameters into configuration file.
}
\details{
If you call \code{save_connection()} without arguments,
    then the current values of the connection parameters  (including NAs)
    will be written to the configuration file.
    If you provide some arguments, they will be written
    into the configuration file. If configuration file is absent
    it will be created in the atsd package folder.
}
\examples{
# Write the current values of the connection parameters to the configuration file
save_connection()

# Write the user name and the password to the configuration file
save_connection(user = "user001", password = "123456")

# Write all parameters nedeed for https connection to the configuration file
save_connection(url = "https://my.company.com:8443", user = "user001", password = "123456",
                verify = "no", encryption = "ssl3")
}
\seealso{
For more information about the configuration file
    view the package vignette:
    \code{browseVignettes(package = "atsd")}.
}

