% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pfa.R
\name{write_pfa}
\alias{write_pfa}
\title{write_pfa}
\usage{
write_pfa(doc, file = "", force = TRUE, auto_unbox = TRUE,
  pretty = FALSE, digits = 8, ...)
}
\arguments{
\item{doc}{The document to convert.}

\item{file}{a string representing file path to write to. If '' then the 
string of JSON is returned}

\item{force}{a logical indicating to unclass/skip objects of classes with no defined JSON mapping}

\item{auto_unbox}{a logical indicating to automatically unbox all atomic vectors of length 1}

\item{pretty}{a logical indicating to add indentation whitespace to JSON output.}

\item{digits}{max number of decimal digits to print for numeric values. 
Use I() to specify significant digits. Use NA for max precision.}

\item{...}{additional arguments passed to toJSON}
}
\description{
Convert a PFA list of lists into a JSON string in memory or a 
JSON file on disk.
}
\examples{
\dontrun{
my_pfa_doc <- pfa_document(avro_double, avro_double, expression(input + 10))
write_pfa(my_pfa_doc)
write_pfa(my_pfa_doc, file = "my-model.pfa")
}
}
