% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplotGO.R
\name{barplotGO}
\alias{barplotGO}
\title{barplotGO}
\usage{
barplotGO(
  enrich_tables,
  title = NULL,
  outfolder = NULL,
  outfile = "barplotGO.png",
  from_autoGO = TRUE
)
}
\arguments{
\item{enrich_tables}{Dataframe containing the enrichment results or a path to your .tsv file containing the enrichment results. Columns 'Term' and 'Adjusted.P.Value' are required.}

\item{title}{Default to NULL, only specify if from_autoGO is FALSE. When enrich_tables is not from autoGO and thus from read_enrich_tables, the user can specify title and subtitle of the plot as 2-element character vector, for example: c("This is the title", "this is the subtitle")}

\item{outfolder}{Default to NULL, only specify if from_autoGO is FALSE. The name to assign to the folder for output saving.}

\item{outfile}{Default to "barplotGO.png", is ignored if from_autoGO is TRUE. The name of the barplot filename.}

\item{from_autoGO}{Default is TRUE, set to FALSE if the enrichment tables you want to use are not from a differential expression analysis.}
}
\value{
No return value. Files will be produced as part of normal execution.
}
\description{
The function barplotGO.R implement the barplot of the first 15 enrichment terms.

For each enrichment result table a barplot is produced. Results are stored in the "enrichment_plots" subfolder for each comparison.
}
\examples{
\dontrun{
barplotGO(
  enrich_tables = enrich_tables,
  title = NULL,
  outfolder = NULL,
  outfile = NULL,
  from_autoGO = TRUE
)
}
}
