% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze_sub.R
\name{gazeCont}
\alias{gazeCont}
\title{Summary function for continuous variable}
\usage{
gazeCont(
  data,
  x,
  y = NULL,
  max.ylev = 5,
  digits = 1,
  show.total = FALSE,
  show.n = FALSE,
  show.missing = FALSE,
  show.stats = TRUE,
  show.p = TRUE,
  method = 1,
  origData,
  ...
)
}
\arguments{
\item{data}{A data.frame}

\item{x}{A name of variable}

\item{y}{A name of variable, either continuous or categorical}

\item{max.ylev}{max.ylev An integer indicating the maximum number of levels of grouping variable ('y').
If a column have unique values less than max.ylev it is treated as a categorical variable. Default value is 5.}

\item{digits}{integer indicating the number of decimal places}

\item{show.total}{logical. Whether or not show total column}

\item{show.n}{logical. Whether or not show N column}

\item{show.missing}{logical. Whether or not show missing column}

\item{show.stats}{logical. Whether or not show stats column}

\item{show.p}{logical. Whether or not show p column}

\item{method}{method    An integer indicating methods for continuous variables. Possible values in methods are
1 forces analysis as normal-distributed
2 forces analysis as continuous non-normal
3 performs a Shapiro-Wilk test or nortest::ad.test to decide between normal or non-normal
Default value is 1.}

\item{origData}{A data.frame containing original data}

\item{...}{Further arguments}
}
\value{
An object of class "data.frame" or "tibble"
}
\description{
Summary function for continuous variable
}
\examples{
gazeCont(mtcars,"hp")
gazeCont(mtcars,"hp","mpg")
require(moonBook)
gazeCont(acs,"log(age)")
gazeCont(acs,"age",method=2)
gazeCont(acs,"age","EF",method=2)
gazeCont(acs,"age","Dx",method=1)
gazeCont(acs,"age","Dx",show.p=TRUE,method=3)
}
