% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptext.R
\name{ptext}
\alias{ptext}
\title{Projected text function}
\usage{
ptext(x, y = NULL, labels, proj, ...)
}
\arguments{
\item{x}{numeric vectors of coordinates where the text
    \code{labels} should be written.  If the length of \code{x} and
    \code{y} differs, the shorter one is recycled.}

\item{y}{numeric vectors of coordinates where the text
    \code{labels} should be written.  If the length of \code{x} and
    \code{y} differs, the shorter one is recycled.}

\item{labels}{a character vector or \link{expression} specifying
    the \emph{text} to be written.  An attempt is made to coerce other
    language objects (names and calls) to expressions, and vectors and
    other classed objects to character vectors by \code{\link{as.character}}.
    If \code{labels} is longer than \code{x} and
    \code{y}, the coordinates are recycled to the length of \code{labels}.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{...}{further \link[graphics]{graphical parameters} (from \code{\link[graphics]{par}}),
    such as \code{srt}, \code{family} and \code{xpd}.}
}
\description{
\code{ptext} draws the character strings given in \code{labels} at
the provided coordinates, possibly after projection.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used for 
projection.

A non-character \code{labels} argument is automatically converted 
to a \code{character} vector using \code{link[base]{as.character}}.
}
\examples{
data(narccap)
# plot image using bonne projection (w/o grid lines)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 40, paxes.args = list(grid = FALSE))
# get national boundaries
data(worldMapEnv, package = "maps")
worldpoly <- maps::map("world", plot = FALSE)
plines(worldpoly, proj = "bonne")
# add U.S. city names to existing plot
data(us.cities, package = "maps")
citysmall <- head(us.cities)
ptext(x = citysmall$lon, y = citysmall$lat, 
      labels = citysmall$name, proj = "bonne")
}
\seealso{
\code{\link[graphics]{text}}, 
  \code{\link[mapproj]{mapproject}},
  \code{\link[autoimage]{pimage}}
}
