#' aves_peru_2023 Dataset
#'
#' The aves_peru_2023 dataset comprises a tibble containing information
#' regarding bird species documented in Peru, sourced from the "List of the
#' Birds of Peru" compiled by M. A. Plenge in 2023. It encompasses various
#' details, including scientific names, English names, Spanish names, order,
#'  family, and status of each species.
#'
#' @format A tibble with 1,892 rows and 6 columns:
#'   \describe{
#'     \item{scientific_name}{Scientific name of the bird species.}
#'     \item{english_name}{English common name of the bird species.}
#'     \item{spanish_name}{Spanish common name of the bird species.}
#'     \item{order}{The order to which the bird species belongs.}
#'     \item{family}{The family to which the bird species belongs.}
#'     \item{status}{Status of the bird species (e.g., resident, endémic,
#'     migratory, etc.).}
#'   }
#'
#'
#' @details This dataset is designed to provide users with comprehensive
#' information about the avian species found in Peru, as documented
#' by M. A. Plenge. It is organized for easy access and utilization within
#' the R environment.
#'
#' @examples
#' # Load the avesperu package
#' library(avesperu)
#'
#' # Access the avesperu_tab dataset
#' data("aves_peru_2023")
#'
#' # Display the first few rows
#' head(aves_peru_2023)
#'
#' @seealso
#' For more information about the "avesperu" package and the data sources, visit
#' the package's GitHub repository: \url{https://github.com/PaulESantos/avesperu}
#'
#' @references
#' The dataset is based on the "List of the Birds of Peru" by M. A. Plenge.
#'
#' @author
#' Data compilation: M. A. Plenge, Package implementation: Paul Efren Santos Andrade
#'
#' @keywords dataset
"aves_peru_2023"
