% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_accept_transit_gateway_peering_attachment}
\alias{ec2_accept_transit_gateway_peering_attachment}
\title{Accept Transit Gateway Peering Attachment}
\usage{
ec2_accept_transit_gateway_peering_attachment(
  TransitGatewayAttachmentId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayAttachmentId}{String. The ID of the transit gateway attachment.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Accepts a transit gateway peering attachment
request. The peering attachment must be in the \code{pendingAcceptance}
state.
}
\section{TransitGatewayAttachmentId}{

The ID of the transit
gateway attachment.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

