% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_copy_fpga_image}
\alias{ec2_copy_fpga_image}
\title{Copy Fpga Image}
\usage{
ec2_copy_fpga_image(
  SourceFpgaImageId,
  SourceRegion,
  DryRun = NULL,
  Description = NULL,
  Name = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SourceFpgaImageId}{String. The ID of the source AFI.}

\item{SourceRegion}{String. The Region that contains the source AFI.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Description}{String. The description for the new AFI.[optional]}

\item{Name}{String. The name for the new AFI. The default is the name of the source AFI.[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Copies the specified Amazon FPGA Image
(AFI) to the current Region.
}
\section{SourceFpgaImageId}{

The ID of the source
AFI.
}

\section{SourceRegion}{

The Region that contains the source
AFI.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Description}{

The description for the new
AFI.
}

\section{Name}{

The name for the new AFI. The default is the
name of the source AFI.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

