% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpc}
\alias{ec2_create_vpc}
\title{Create Vpc}
\usage{
ec2_create_vpc(
  CidrBlock,
  AmazonProvidedIpv6CidrBlock = NULL,
  Ipv6Pool = NULL,
  Ipv6CidrBlock = NULL,
  DryRun = NULL,
  InstanceTenancy = NULL,
  Ipv6CidrBlockNetworkBorderGroup = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CidrBlock}{String. The IPv4 network range for the VPC, in CIDR notation.}

\item{AmazonProvidedIpv6CidrBlock}{Logical. Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.[optional]}

\item{Ipv6Pool}{String. The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.[optional]}

\item{Ipv6CidrBlock}{String.   The IPv6 CIDR block from the IPv6 address pool.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{InstanceTenancy}{String.   The tenancy options for instances launched into the VPC.[optional]}

\item{Ipv6CidrBlockNetworkBorderGroup}{String.   The name of the location from which we advertise the IPV6 CIDR block.[optional]}

\item{TagSpecification}{List. The tags to assign to the VPC.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Vpc
}
\section{CidrBlock}{

The IPv4 network range for the VPC, in CIDR
notation. For example, \verb{10.0.0.0/16}. We modify the specified CIDR block
to its canonical form; for example, if you specify \verb{100.68.0.18/18}, we
modify it to \verb{100.68.0.0/18}.
}

\section{AmazonProvidedIpv6CidrBlock}{

Requests an
Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
You cannot specify the range of IP addresses, or the size of the CIDR
block.
}

\section{Ipv6Pool}{

The ID of an IPv6 address pool from which to
allocate the IPv6 CIDR block.
}

\section{Ipv6CidrBlock}{


The IPv6 CIDR block from the IPv6 address pool. You must also specify
\code{Ipv6Pool} in the request.

To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{InstanceTenancy}{


The tenancy options for instances launched into the VPC. For \code{default},
instances are launched with shared tenancy by default. You can launch
instances with any tenancy into a shared tenancy VPC. For \code{dedicated},
instances are launched as dedicated tenancy instances by default. You
can only launch instances with a tenancy of \code{dedicated} or \code{host} into a
dedicated tenancy VPC.

\strong{Important:} The \code{host} value cannot be used with this parameter. Use
the \code{default} or \code{dedicated} values only.

Default: \code{default}
}

\section{Ipv6CidrBlockNetworkBorderGroup}{


The name of the location from which we advertise the IPV6 CIDR block.
Use this parameter to limit the address to this location.

You must set \code{AmazonProvidedIpv6CidrBlock} to \code{true} to use this
parameter.
}

\section{TagSpecification}{

The tags to assign to the
VPC.
}

