% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_snapshot_attribute}
\alias{ec2_describe_snapshot_attribute}
\title{Describe Snapshot Attribute}
\usage{
ec2_describe_snapshot_attribute(
  Attribute,
  SnapshotId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Attribute}{String. The snapshot attribute you would like to view.}

\item{SnapshotId}{String. The ID of the EBS snapshot.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Snapshot Attribute
}
\section{Attribute}{

The snapshot attribute you would like
to view.
}

\section{SnapshotId}{

The ID of the EBS
snapshot.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

