% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_fleet}
\alias{ec2_modify_fleet}
\title{Modify Fleet}
\usage{
ec2_modify_fleet(
  FleetId,
  DryRun = NULL,
  ExcessCapacityTerminationPolicy = NULL,
  LaunchTemplateConfig = NULL,
  TargetCapacitySpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{FleetId}{String. The ID of the EC2 Fleet.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ExcessCapacityTerminationPolicy}{String. Indicates whether running instances should be terminated if the total target capacity of the EC2...[optional]}

\item{LaunchTemplateConfig}{List. The launch template and overrides.[optional]}

\item{TargetCapacitySpecification}{Object. The size of the EC2 Fleet.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Fleet
}
\section{FleetId}{

The ID of the EC2
Fleet.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ExcessCapacityTerminationPolicy}{

Indicates whether running
instances should be terminated if the total target capacity of the EC2
Fleet is decreased below the current size of the EC2
Fleet.
}

\section{LaunchTemplateConfig}{

The launch template and
overrides.
}

\section{TargetCapacitySpecification}{

The size of the EC2
Fleet.
}

