% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_identity_id_format}
\alias{ec2_modify_identity_id_format}
\title{Modify Identity Id Format}
\usage{
ec2_modify_identity_id_format(
  PrincipalArn,
  Resource,
  UseLongIds,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PrincipalArn}{String. The ARN of the principal, which can be an IAM user, IAM role, or the root user.}

\item{Resource}{String.   The type of resource: \code{bundle} \| \code{conversion-task} \| \code{customer-gateway} \| \code{dhcp-options} \|...}

\item{UseLongIds}{Logical. Indicates whether the resource should use longer IDs (17-character IDs)}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Identity Id Format
}
\section{PrincipalArn}{

The ARN of the principal, which
can be an IAM user, IAM role, or the root user. Specify \code{all} to modify
the ID format for all IAM users, IAM roles, and the root user of the
account.
}

\section{Resource}{


The type of resource: \code{bundle} \| \code{conversion-task} \|
\code{customer-gateway} \| \code{dhcp-options} \| \code{elastic-ip-allocation} \|
\code{elastic-ip-association} \| \code{export-task} \| \code{flow-log} \| \code{image} \|
\code{import-task} \| \code{internet-gateway} \| \code{network-acl} \|
\code{network-acl-association} \| \code{network-interface} \|
\code{network-interface-attachment} \| \code{prefix-list} \| \code{route-table} \|
\code{route-table-association} \| \code{security-group} \| \code{subnet} \|
\code{subnet-cidr-block-association} \| \code{vpc} \| \code{vpc-cidr-block-association}
\| \code{vpc-endpoint} \| \code{vpc-peering-connection} \| \code{vpn-connection} \|
\code{vpn-gateway}.

Alternatively, use the \code{all-current} option to include all resource
types that are currently within their opt-in period for longer IDs.
}

\section{UseLongIds}{

Indicates whether the resource should use longer
IDs (17-character IDs)
}

