% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_deregister_container_instance}
\alias{ecs_deregister_container_instance}
\title{Deregister Container Instance}
\usage{
ecs_deregister_container_instance(
  cluster = NULL,
  containerInstance = NULL,
  force = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{cluster}{String. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance...}

\item{containerInstance}{String. The container instance ID or full ARN of the container instance to deregister.}

\item{force}{Logical.   Forces the deregistration of the container instance.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deregister Container Instance
}
\section{cluster}{

The short name or full Amazon Resource Name
(ARN) of the cluster that hosts the container instance to deregister. If
you do not specify a cluster, the default cluster is
assumed.
}

\section{containerInstance}{

The container instance ID or full ARN of
the container instance to deregister. The ARN contains the \code{arn:aws:ecs}
namespace, followed by the Region of the container instance, the AWS
account ID of the container instance owner, the \code{container-instance}
namespace, and then the container instance ID. For example,
\code{arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID}.
}

\section{force}{


Forces the deregistration of the container instance. If you have tasks
running on the container instance when you deregister it with the
\code{force} option, these tasks remain running until you terminate the
instance or the tasks stop through some other means, but they are
orphaned (no longer monitored or accounted for by Amazon ECS). If an
orphaned task on your container instance is part of an Amazon ECS
service, then the service scheduler starts another copy of that task, on
a different container instance if possible.

Any containers in orphaned service tasks that are registered with a
Classic Load Balancer or an Application Load Balancer target group are
deregistered. They begin connection draining according to the settings
on the load balancer or target group.
}

