% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_instance_placement}
\alias{ec2_modify_instance_placement}
\title{Modify Instance Placement}
\usage{
ec2_modify_instance_placement(
  InstanceId,
  Affinity = NULL,
  GroupName = NULL,
  HostId = NULL,
  Tenancy = NULL,
  PartitionNumber = NULL,
  HostResourceGroupArn = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{InstanceId}{Character. The ID of the instance that you are modifying.}

\item{Affinity}{Character. The affinity setting for the instance.[optional]}

\item{GroupName}{Character.   The name of the placement group in which to place the instance.[optional]}

\item{HostId}{Character. The ID of the Dedicated Host with which to associate the instance.[optional]}

\item{Tenancy}{Character. The tenancy for the instance.[optional]}

\item{PartitionNumber}{Integer. Reserved for future use.[optional]}

\item{HostResourceGroupArn}{Character. The ARN of the host resource group in which to place the instance.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Instance Placement
}
\section{InstanceId}{

The ID of the instance that
you are modifying.
}

\section{Affinity}{

The affinity setting for the
instance.
}

\section{GroupName}{


The name of the placement group in which to place the instance. For
spread placement groups, the instance must have a tenancy of \code{default}.
For cluster and partition placement groups, the instance must have a
tenancy of \code{default} or \code{dedicated}.

To remove an instance from a placement group, specify an empty string
(\'\').
}

\section{HostId}{

The ID of the Dedicated Host with which to
associate the instance.
}

\section{Tenancy}{

The tenancy for the
instance.
}

\section{PartitionNumber}{

Reserved for future
use.
}

\section{HostResourceGroupArn}{

The ARN of the host resource group in which to
place the instance.
}

