% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accelerate.R
\name{get_acceleration}
\alias{get_acceleration}
\alias{put_acceleration}
\title{Bucket Acceleration}
\usage{
get_acceleration(bucket, ...)

put_acceleration(bucket, status = c("Enabled", "Suspended"), ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{status}{Character string specifying whether acceleration should be \dQuote{Enabled} or \dQuote{Suspended}.}
}
\value{
For \code{get_acceleration}: If acceleration has never been enabled or suspend, the value is \code{NULL}. Otherwise, the status is returned (either \dQuote{Enabled} or \dQuote{Suspended}). For \code{put_acceleration}: If acceleration has never been enabled or suspend, the value is \code{NULL}.
}
\description{
Get/Put acceleration settings or retrieve acceleration status of a bucket.
}
\details{
Transfer acceleration is a AWS feature that enables potentially faster file transfers to and from S3, particularly when making cross-border transfers (such as from a European client location to the \samp{us-east-1} S3 region). Acceleration must be enabled before it can be used. Once enabled, \code{accelerate = TRUE} can be passed to any aws.s3 function via \code{\link{s3HTTP}}. \code{get_acceleration} returns the acceleration status of a bucket; \code{put_acceleration} enables or suspends acceleration.
}
\examples{
\dontrun{
b <- bucketlist()
get_acceleration(b[[1]])
put_acceleration(b[[1]], "Enabled")
get_acceleration(b[[1]])
put_acceleration(b[[1]], "Suspended")
}
}
\references{
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTaccelerate.html}{API Documentation: PUT Bucket accelerate}
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETaccelerate.html}{API Documentation: GET Bucket accelerate}
}
