% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy.R
\name{get_bucket_policy}
\alias{get_bucket_policy}
\alias{put_bucket_policy}
\alias{delete_bucket_policy}
\title{Bucket policies}
\usage{
get_bucket_policy(bucket, parse_response = TRUE, ...)

put_bucket_policy(bucket, policy, ...)

delete_bucket_policy(bucket, ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{parse_response}{A logical indicating whether to return the response as is, or parse and return as a list. Default is \code{FALSE}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{policy}{A character string containing a bucket policy.}
}
\value{
For \code{get_policy}: A character string containing the JSON representation of the policy, if one has been set. For \code{delete_policy} and \code{put_policy}: \code{TRUE} if successful, \code{FALSE} otherwise.
}
\description{
Get/Put/Delete the bucket access policy for a bucket.
}
\details{
Bucket policies regulate who has what access to a bucket and its contents. The \code{header} argument can beused to specify \dQuote{canned} policies and \code{\link{put_bucket_policy}} can be used to specify a more complex policy. The \href{https://awspolicygen.s3.amazonaws.com/policygen.html}{AWS Policy Generator} can be useful for creating the appropriate JSON policy structure.
}
\references{
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETpolicy.html}{API Documentation}
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketDELETEpolicy.html}{API Documentation}
\href{https://awspolicygen.s3.amazonaws.com/policygen.html}{AWS Policy Generator}
}
