% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3read_using.R
\name{s3write_using}
\alias{s3write_using}
\alias{s3read_using}
\title{Custom read and write}
\usage{
s3write_using(x, FUN, ..., object, bucket, opts = NULL)

s3read_using(FUN, ..., object, bucket, opts = NULL)
}
\arguments{
\item{x}{For \code{s3write_using}, a single R object to be saved via the first argument to \code{FUN} and uploaded to S3.}

\item{FUN}{For \code{s3write_using}, a function to which \code{x} and a file path will be passed (in that order).}

\item{...}{Additional arguments to \code{FUN}}

\item{object}{Character string with the object key, or an object of class \dQuote{s3_object}. In most cases, if \code{object} is specified as the latter, \code{bucket} can be omitted because the bucket name will be extracted from \dQuote{Bucket} slot in \code{object}.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{opts}{Optional additional arguments passed to \code{\link{put_object}} or \code{\link{save_object}}, respectively.}
}
\value{
For \code{s3write_using}, a logical, invisibly. For \code{s3read_using}, the output of \code{FUN} applied to the file from \code{object}.
}
\description{
Read/write objects from/to S3 using a custom function
}
\examples{
\dontrun{
library("datasets")
# create bucket
b <- put_bucket("myexamplebucket")

# save a dataset to the bucket as a csv
if (require("utils")) {
  s3write_using(mtcars, FUN = write.csv, object = "mtcars.csv", bucket = b)
}

# load dataset from the bucket as a csv
if (require("utils")) {
  s3read_using(FUN = read.csv, object = "mtcars.csv", bucket = b)
}

# cleanup
delete_object(object = "mtcars.csv", bucket = b)
delete_bucket(bucket = b)
}
}
\seealso{
\code{\link{s3saveRDS}}, \code{\link{s3readRDS}}, \code{\link{put_object}},\code{\link{get_object}}
}
