% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagging.R
\name{get_tagging}
\alias{get_tagging}
\alias{put_tagging}
\alias{delete_tagging}
\title{Bucket tagging}
\usage{
get_tagging(bucket, ...)

put_tagging(bucket, tags = list(), ...)

delete_tagging(bucket, ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{tags}{A list containing key-value pairs of tag names and values.}
}
\value{
A list containing the tag set, if one has been set. For \code{delete_tagging}: \code{TRUE} if successful, \code{FALSE} otherwise.
}
\description{
Get/delete the tag set for a bucket.
}
\examples{
\dontrun{
 put_tagging("mybucket", tags = list(foo = "1", bar = "2"))
 get_tagging("mybucket")
 delete_tagging("mybucket")
}

}
\references{
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTtagging.html}{API Documentation: PUT tagging}
 \href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETtagging.html}{API Documentation: GET tagging}
 \href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketDELETEtagging.html}{API Documentation: DELETE tagging}
}
