% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite.add.blocks.R
\name{bipartite.add.blocks}
\alias{bipartite.add.blocks}
\title{Adds a block structure to a bipartite network}
\usage{
bipartite.add.blocks(B, blocks = 2, density = 0.5, max.tries = 1e+05)
}
\arguments{
\item{B}{A bipartite network object of class "matrix", "sparseMatrix", \link{igraph}, matrix or dataframe edgelist, or \link[network]{network}}

\item{blocks}{integer: number of blocks to add (between 2 and 26)}

\item{density}{numeric: desired within-block density}

\item{max.tries}{numeric: number of ineligible re-wiring attempts before giving up}
}
\description{
`bipartite.add.blocks` rewires a bipartite graph B to have a block structure such that edges are
located within-block with `density` probability, while preserving both degree distributions.
}
\details{
Each row node and each column node are randomly assigned to one of `blocks` number of groups. Then
degree-preserving checkerboard swaps are performed that increase the within-block density, until `density`
is achieved. Eligible swaps are identified randomly, so the re-wiring can be slow when B is large. The process
can get stuck when no eligible swaps remain but the target `density` has not been achieved; if this happens, increase
`max.tries` to keep looking for eligible swaps or reduce the target `density`.
}
\examples{
B <- bipartite.from.probability(R = 10, C = 10, P = .5)
B <- bipartite.add.blocks(B, blocks = 2, density = .7)
}
