% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.banter_model}
\alias{summary,banter_model-method}
\title{BANTER Classifier Model Summary}
\usage{
summary(object, ...)

\method{summary}{banter_model}(object, model = "event", n = 0.5, bins = 20, ...)

\S4method{summary}{banter_model}(object, model = "event", n = 0.5, bins = 20, ...)
}
\arguments{
\item{object}{a \code{\link{banter_model}} object.}

\item{...}{ignored.}

\item{model}{name of model to summarize. Default is \code{"event"} 
to summarize the event-level model. Can also be name of a detector.}

\item{n}{number of final iterations to summarize OOB error rate for. If 
between 0 and 1 is taken as a proportion of chain.}

\item{bins}{number of bins in inbag histogram.}
}
\value{
In the plot that is created, the upper panel shows the trace of the 
  Random Forest model OOB rate across sequential trees in the forest. The
  lower plot shows a frequency histogram of the number of times each sample 
  was inbag (used as training data in a tree in the forest). The vertical 
  red lines indicate the expected inbag rate for samples of each species.
}
\description{
Display summaries for event and detector models
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 1, num.cores = 1
)
# run BANTER event model
bant.mdl <- runBanterModel(bant.mdl, ntree = 1000, sampsize = 1)
summary(bant.mdl)

}
\references{
Rankin, S. , Archer, F. , Keating, J. L., Oswald, J. N., 
  Oswald, M. , Curtis, A. and Barlow, J. (2017), Acoustic classification 
  of dolphins in the California Current using whistles, echolocation clicks,
  and burst pulses. Marine Mammal Science 33:520-540. doi:10.1111/mms.12381
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
