% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chadwick_playerid_lookup.R
\name{playerid_lookup}
\alias{playerid_lookup}
\title{\strong{Look up Baseball Player IDs by Player Name}}
\usage{
playerid_lookup(last_name = NULL, first_name = NULL)
}
\arguments{
\item{last_name}{A text string used to return results for players with that string in their last name.}

\item{first_name}{A text string used to return results for players with that string in their first name.}
}
\value{
A data frame of baseball players and the various IDs associated with them in different systems of record.\tabular{ll}{
   col_name \tab types \cr
   first_name \tab character \cr
   last_name \tab character \cr
   given_name \tab character \cr
   name_suffix \tab character \cr
   nick_name \tab character \cr
   birth_year \tab integer \cr
   mlb_played_first \tab integer \cr
   mlbam_id \tab integer \cr
   retrosheet_id \tab character \cr
   bbref_id \tab character \cr
   fangraphs_id \tab integer \cr
}
}
\description{
This function allows you to query the Chadwick Bureau's public register of baseball players and the various IDs associated with them in different systems of record.
}
\examples{
\donttest{
  try(playerid_lookup("Garcia", "Karim"))
}
}
