% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_teams_stats.R
\name{mlb_teams_stats}
\alias{mlb_teams_stats}
\title{\strong{MLB Teams Stats}}
\usage{
mlb_teams_stats(
  stat_type = NULL,
  game_type = NULL,
  stat_group = NULL,
  season = NULL,
  sport_ids = NULL,
  sort_stat = NULL,
  order = NULL
)
}
\arguments{
\item{stat_type}{Stat type to return statistics for.}

\item{game_type}{Game type to return information for a particular statistic in a particular game type.}

\item{stat_group}{Stat group to return information and ranking for a particular statistic in a particular group.}

\item{season}{Year to return information and ranking for a particular statistic in a given year.}

\item{sport_ids}{The sport_id(s) to return information and ranking information for.}

\item{sort_stat}{Sort return based on stat.}

\item{order}{Order return based on either desc or asc.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   total_splits \tab integer \cr
   season \tab character \cr
   rank \tab integer \cr
   games_played \tab integer \cr
   ground_outs \tab integer \cr
   air_outs \tab integer \cr
   runs \tab integer \cr
   doubles \tab integer \cr
   triples \tab integer \cr
   home_runs \tab integer \cr
   strike_outs \tab integer \cr
   base_on_balls \tab integer \cr
   intentional_walks \tab integer \cr
   hits \tab integer \cr
   hit_by_pitch \tab integer \cr
   avg \tab character \cr
   at_bats \tab integer \cr
   obp \tab character \cr
   slg \tab character \cr
   ops \tab character \cr
   caught_stealing \tab integer \cr
   stolen_bases \tab integer \cr
   stolen_base_percentage \tab character \cr
   ground_into_double_play \tab integer \cr
   number_of_pitches \tab integer \cr
   plate_appearances \tab integer \cr
   total_bases \tab integer \cr
   rbi \tab integer \cr
   left_on_base \tab integer \cr
   sac_bunts \tab integer \cr
   sac_flies \tab integer \cr
   babip \tab character \cr
   ground_outs_to_airouts \tab character \cr
   catchers_interference \tab integer \cr
   at_bats_per_home_run \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   splits_tied_with_offset \tab list \cr
   splits_tied_with_limit \tab list \cr
   type_display_name \tab character \cr
   group_display_name \tab character \cr
}
}
\description{
\strong{MLB Teams Stats}
}
\examples{
\donttest{
  try(mlb_teams_stats(stat_type = 'season', stat_group = 'hitting', season = 2021))
}
}
