% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_awards_recipient.R
\name{mlb_awards_recipient}
\alias{mlb_awards_recipient}
\title{\strong{MLB Award Recipients}}
\usage{
mlb_awards_recipient(
  award_id = NULL,
  sport_id = NULL,
  league_id = NULL,
  season = NULL
)
}
\arguments{
\item{award_id}{award_id to return a directory of players for a given award.}

\item{sport_id}{sport_id to return a directory of players for a given aware in a specific sport.}

\item{league_id}{league_id(s) to return a directory of players for a given award in a specific league. Format '103,104'}

\item{season}{Year(s) to return a directory of players for a given award in a given season.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   award_id \tab character \cr
   award_name \tab character \cr
   date \tab character \cr
   season \tab character \cr
   votes \tab integer \cr
   notes \tab character \cr
   player_id \tab integer \cr
   player_link \tab character \cr
   player_name_first_last \tab character \cr
   player_primary_position_code \tab character \cr
   player_primary_position_name \tab character \cr
   player_primary_position_type \tab character \cr
   player_primary_position_abbreviation \tab character \cr
   team_id \tab integer \cr
   team_link \tab character \cr
}
}
\description{
\strong{MLB Award Recipients}
}
\examples{
\donttest{
  try(mlb_awards_recipient(award_id = 'MLBHOF', season = 2020))
}
}
