% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_game_changes.R
\name{mlb_game_changes}
\alias{mlb_game_changes}
\title{\strong{Acquire time codes for Major and Minor League games}}
\usage{
mlb_game_changes(updated_since, sport_id)
}
\arguments{
\item{updated_since}{Updated since date time}

\item{sport_id}{Return division(s) for all divisions in a specific sport.}
}
\value{
Returns a tibble that includes time codes from the game_pk requested\tabular{ll}{
   col_name \tab types \cr
   date \tab character \cr
   total_items \tab integer \cr
   total_events \tab integer \cr
   total_games \tab integer \cr
   total_games_in_progress \tab integer \cr
   game_pk \tab integer \cr
   link \tab character \cr
   game_type \tab character \cr
   season \tab character \cr
   game_date \tab character \cr
   official_date \tab character \cr
   is_tie \tab logical \cr
   game_number \tab integer \cr
   public_facing \tab logical \cr
   double_header \tab character \cr
   gameday_type \tab character \cr
   tiebreaker \tab character \cr
   calendar_event_id \tab character \cr
   season_display \tab character \cr
   day_night \tab character \cr
   description \tab character \cr
   scheduled_innings \tab integer \cr
   reverse_home_away_status \tab logical \cr
   inning_break_length \tab integer \cr
   games_in_series \tab integer \cr
   series_game_number \tab integer \cr
   series_description \tab character \cr
   record_source \tab character \cr
   if_necessary \tab character \cr
   if_necessary_description \tab character \cr
   status_abstract_game_state \tab character \cr
   status_coded_game_state \tab character \cr
   status_detailed_state \tab character \cr
   status_status_code \tab character \cr
   status_start_time_tbd \tab logical \cr
   status_abstract_game_code \tab character \cr
   teams_away_score \tab integer \cr
   teams_away_is_winner \tab logical \cr
   teams_away_split_squad \tab logical \cr
   teams_away_series_number \tab integer \cr
   teams_away_league_record_wins \tab integer \cr
   teams_away_league_record_losses \tab integer \cr
   teams_away_league_record_pct \tab character \cr
   teams_away_team_id \tab integer \cr
   teams_away_team_name \tab character \cr
   teams_away_team_link \tab character \cr
   teams_home_score \tab integer \cr
   teams_home_is_winner \tab logical \cr
   teams_home_split_squad \tab logical \cr
   teams_home_series_number \tab integer \cr
   teams_home_league_record_wins \tab integer \cr
   teams_home_league_record_losses \tab integer \cr
   teams_home_league_record_pct \tab character \cr
   teams_home_team_id \tab integer \cr
   teams_home_team_name \tab character \cr
   teams_home_team_link \tab character \cr
   venue_id \tab integer \cr
   venue_name \tab character \cr
   venue_link \tab character \cr
   content_link \tab character \cr
   status_reason \tab character \cr
   rescheduled_from \tab character \cr
   rescheduled_from_date \tab character \cr
   resumed_from \tab character \cr
   resumed_from_date \tab character \cr
   events \tab list \cr
}
}
\description{
\strong{Acquire time codes for Major and Minor League games}
}
\examples{
\donttest{
  try(mlb_game_changes(updated_since = "2021-08-10T19:08:24.000004Z", sport_id = 1))
}
}
