% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_homerun_derby.R
\name{mlb_homerun_derby_bracket}
\alias{mlb_homerun_derby_bracket}
\title{\strong{Retrieve Homerun Derby Bracket}}
\usage{
mlb_homerun_derby_bracket(game_pk)
}
\arguments{
\item{game_pk}{The game_pk for which you want to return data}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   game_pk \tab integer \cr
   event_name \tab character \cr
   event_type_code \tab character \cr
   event_type_name \tab character \cr
   event_date \tab character \cr
   venue_id \tab integer \cr
   venue_name \tab character \cr
   venue_link \tab character \cr
   is_multi_day \tab logical \cr
   is_primary_calendar \tab logical \cr
   file_code \tab character \cr
   event_number \tab integer \cr
   public_facing \tab logical \cr
   round \tab integer \cr
   num_batters \tab integer \cr
   top_seed_complete \tab logical \cr
   top_seed_started \tab logical \cr
   top_seed_winner \tab logical \cr
   top_seed_seed \tab integer \cr
   top_seed_is_winner \tab logical \cr
   top_seed_is_complete \tab logical \cr
   top_seed_is_started \tab logical \cr
   top_seed_num_home_runs \tab integer \cr
   top_seed_player_id \tab integer \cr
   top_seed_player_full_name \tab character \cr
   top_seed_player_link \tab character \cr
   top_seed_top_derby_hit_data_launch_speed \tab integer \cr
   top_seed_top_derby_hit_data_total_distance \tab integer \cr
   bottom_seed_complete \tab logical \cr
   bottom_seed_started \tab logical \cr
   bottom_seed_winner \tab logical \cr
   bottom_seed_seed \tab integer \cr
   bottom_seed_is_winner \tab logical \cr
   bottom_seed_is_complete \tab logical \cr
   bottom_seed_is_started \tab logical \cr
   bottom_seed_num_home_runs \tab integer \cr
   bottom_seed_player_id \tab integer \cr
   bottom_seed_player_full_name \tab character \cr
   bottom_seed_player_link \tab character \cr
   bottom_seed_top_derby_hit_data_launch_speed \tab integer \cr
   bottom_seed_top_derby_hit_data_total_distance \tab integer \cr
}
}
\description{
\strong{Retrieve Homerun Derby Bracket}
}
\examples{
\donttest{
  try(mlb_homerun_derby_bracket(game_pk = 511101))
}
}
