% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fasta.R
\name{read.fasta}
\alias{read.fasta}
\title{Read sequences from a FASTA file}
\usage{
read.fasta(file_path)
}
\arguments{
\item{file_path}{The path to the FASTA file to read in.}
}
\value{
A list of sequences, where each sequence is associated with its
sequence name.
}
\description{
This function reads in a FASTA file and returns a list of sequences,
where each sequence is associated with its sequence name.
}
\examples{
\donttest{
# Read in sequences from a FASTA file

sample_file_path <- system.file("extdata", "sample.fasta", package = "baseq")

seqs <- read.fasta(sample_file_path)

# Access a specific sequence by name
seqs[["sequence_name"]]
}
}
