% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.bayesbr.R
\name{logLik.bayesbr}
\alias{logLik.bayesbr}
\title{Model Log Likelihood for \code{bayesbr} Objects}
\usage{
\method{logLik}{bayesbr}(object,...)
}
\arguments{
\item{object}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function returns a list with \describe{\item{loglik}{A vector with the estimated model loglik chain,}\item{matrix_loglik}{A matrix with all loglik's chain.}}
}
\description{
A function that receives the information from the estimated model, the response variable and the theta and zeta chains and returns a vector containing loglik values for each iteration excluding warmups.
}
\details{
Loglik is commonly used to measure fit quality, or to assess whether an fit has converged. The loglik is calculated using maximum likelihood, but as we are in the Bayesian context we will use the mean of the posterior distribution of the parameters, so the calculation occurs from an adaptation of the original form to the loglik.
}
\examples{
data("CarTask", package = "bayesbr")
bbr = bayesbr(probability~task + NFCCscale, iter = 100,
             data=CarTask, mean_betas = c(1, 0.5,1.2))
loglik = bbr$loglik

loglikPlot(loglik)
}
\references{
\doi{10.1080/0266476042000214501} Ferrari, S.L.P., and Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. \emph{Journal of Applied Statistics}, \bold{31}(7), 799–815.
}
\seealso{
\code{\link{bayesbr}},\code{\link{residuals.bayesbr}},\code{\link{loglikPlot}}
}
