% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{accuracy}
\alias{accuracy}
\title{Compute Prediction Accuracy}
\usage{
accuracy(object, prediction, balanced = FALSE)
}
\arguments{
\item{object}{Object of class \code{bbl} with test data in \code{data} slot.}

\item{prediction}{Data frame of predicted response group probability from
\code{\link{predict}}.}

\item{balanced}{Compute balanced accuracy. If \code{TRUE},
\deqn{s = \frac{1}{K}\sum_y \frac{1}{n_y} \sum_{k\in y}
       \delta\left({\hat y}_k = y\right).}
If \code{FALSE},
\deqn{s = \frac{1}{n}\sum_{k}
       \delta\left({\hat y}_k = y_k\right).}}
}
\value{
List of \code{acc} (accuracy score) and \code{yhat} (predicted
response group).
}
\description{
Accuracy of predicted response probability is computed.
}
\details{
An option is provided for computing group-balanced accuracy, where
prediction score is calculated for each group separately and averaged.
}
\examples{
titanic <- freq2raw(as.data.frame(Titanic), Freq='Freq')
nsample <- NROW(titanic)
mod <- bbl(data=titanic, y='Survived')
mod <- mod[sample(nsample),]
mtrain <- mod[seq(nsample/2),]
mtest <- mod[seq(nsample/2,nsample),]
mtrain <- train(mtrain, method='mf')
pred <- predict(mtrain, newdata=mtest@data)
score <- accuracy(mtest, prediction=pred, balanced=TRUE) 
}
