% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{posterior}
\alias{posterior}
\title{update the prior distribution with sufficient statistics}
\usage{
posterior(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None, or an error message if the update fails.
}
\description{
This is a generic function that will update the prior distribution of a "BayesianBrick" object by adding information of the observation's sufficient statistics. i.e. for the model structure: \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
update gamma to gamma_posterior by adding the information of X to gamma
}
\seealso{
\code{\link{posterior.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{posterior.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{posterior.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{posterior.CatDP}} for Categorical-DP conjugate structure ...
}
