% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{sufficientStatistics.GaussianInvWishart}
\alias{sufficientStatistics.GaussianInvWishart}
\title{Sufficient statistics of a "GaussianInvWishart" object}
\usage{
\method{sufficientStatistics}{GaussianInvWishart}(obj, x, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "GaussianInvWishart" object.}

\item{x}{matrix, Gaussian samples, when x is a matrix, each row is a sample of dimension ncol(x). when x is a vector, x is length(x) samples of dimension 1.}

\item{foreach}{logical, specifying whether to return the sufficient statistics for each observation. Default FALSE.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
If foreach=TRUE, will return a list of sufficient statistics for each row of x, otherwise will return the sufficient statistics of x as a whole.
}
\description{
For following model structure:
    \deqn{x ~ Gaussian(mu,Sigma)}
    \deqn{Sigma ~ InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The sufficient statistics of a set of samples x (each row of x is a sample) are: \cr
\itemize{
 \item the effective number of samples N=nrow(x)
 \item the centered sample scatter matrix S = (t(x)-mu)^T %*% (t(x)-mu)
}
}
\examples{
obj <- GaussianInvWishart(gamma=list(mu=c(-1.5,1.5),v=3,S=diag(2)))
x <- rGaussian(10,mu = c(-1.5,1.5),Sigma = matrix(c(0.1,0.03,0.03,0.1),2,2))
sufficientStatistics(obj=obj,x=x,foreach = FALSE)
sufficientStatistics(obj=obj,x=x,foreach = TRUE)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.

MARolA, K. V., JT KBNT, and J. M. Bibly. Multivariate analysis. AcadeInic Press, Londres, 1979.
}
\seealso{
\code{\link{GaussianInvWishart}}, \code{\link{sufficientStatistics_Weighted.GaussianInvWishart}}
}
