% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_data.R
\name{clean_data}
\alias{clean_data}
\title{Data cleaning according to Questionnaire Responses.}
\usage{
clean_data(data, custom_questionnaire = NULL, clean = TRUE,
  missing = FALSE, report = TRUE, format = c("html_document",
  "pdf_document"))
}
\arguments{
\item{data}{Biodiversity data in a data frame}

\item{custom_questionnaire}{Custom user created questionnaire responses if to pypass answering questions each time.}

\item{clean}{Whether to clean after flagging. If false only flagging will be done.}

\item{missing}{How to treat data with missing values. Default: false - will be treated as bad data.}

\item{report}{Whether to print report of cleaning done.}

\item{format}{Formats of the cleaning report required. Options are: Markdown, HTML or / and PDF}
}
\value{
data frame with clean data
}
\description{
Use \code{run_questionnaire} to add Questionnaire Responses and pass it to this
function to process the data faster.
}
\details{
Use \code{create_default_questionnaire} to create default questionnaire object.
You can add your custom questions to this questionnaire and then pass it to this
function to process the data.
}
\examples{

custom_questionnaire <- create_default_questionnaire()

if(interactive()){

library(rgbif)
occdat <- occ_data(
  country = 'AU', # Country code for australia
  classKey = 359, # Class code for mammalia
  limit = 50 # Get only 50 records
)
myData <- occdat$data

responses <- run_questionnaire()
cleaned_data <- clean_data(myData, responses)

cleaned_data2 <- clean_data(myData)

} 

}
